<?xml version="1.0" ?>
<template expand_clusters="true" version="2">
    <!-- Updated on 2025-11-13T16:29:31.819905416 using eu-gerrit-1.euhpc.arm.com:29418/dsg/streamline - origin/changes/83/830983/1 (128f11507b5b58b15280689d64925b5636464515) - "Split out top down timeline charts where there are different divisors" -->
    <supported-cpuid id="Cortex-A55" />
    <chart average_cores="yes" average_selection="yes" height="61" percentage="yes" rendering_type="bar" series_composition="stacked" title="CPU Activity">
        <series color="58,223,67" description="User activity" display="AVERAGE" expression="$CPUActivityUser" name="User activity"/>
        <series color="223,71,66" description="System activity" display="AVERAGE" expression="$CPUActivitySystem" name="System activity"/>
    </chart>   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Backend Stall Interlock Rate">
        <series color="19,148,180" description="This metric is the percentage of total cycles stalled in the backend due to instruction interlocks. A high rate of interlock stalls is likely an indication of sub-optimal instruction scheduling for an in-order core." expression="if(($BackendStallInterlockRateCortexA55STALL_BACKEND &gt; 0), min(($BackendStallInterlockRateCortexA55STALL_BACKEND_ILOCK / $BackendStallInterlockRateCortexA55STALL_BACKEND), 1), 0)" name="Backend Stall Interlock Rate" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Backend Stalled Cycles">
        <series color="19,148,180" description="This metric is the percentage of cycles that were stalled due to resource constraints in the backend unit of the processor" expression="if(($BackendStalledCyclesCortexA55CPU_CYCLES &gt; 0), min(($BackendStalledCyclesCortexA55STALL_BACKEND / $BackendStalledCyclesCortexA55CPU_CYCLES), 1), 0)" name="Backend Stalled Cycles" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Branch Direct Percentage">
        <series color="19,148,180" description="This metric measures the ratio of direct branches retired to the total number of branches architecturally executed" expression="if(($BranchDirectPercentageCortexA55BR_RETIRED &gt; 0), min(($BranchDirectPercentageCortexA55BR_IMMED_RETIRED / $BranchDirectPercentageCortexA55BR_RETIRED), 1), 0)" name="Branch Direct Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Branch Misprediction Percentage">
        <series color="19,148,180" description="This metric measures the ratio of branches mispredicted to the total number of branches architecturally executed. This gives an indication of the effectiveness of the branch prediction unit." expression="if(($BranchMispredictionPercentageCortexA55BR_RETIRED &gt; 0), min(($BranchMispredictionPercentageCortexA55BR_MIS_PRED_RETIRED / $BranchMispredictionPercentageCortexA55BR_RETIRED), 1), 0)" name="Branch Misprediction Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="Branch MPKI">
        <series color="19,148,180" description="This metric measures the number of branch mispredictions per thousand instructions executed" expression="if(($BranchMPKICortexA55INST_RETIRED &gt; 0), (($BranchMPKICortexA55BR_MIS_PRED_RETIRED / $BranchMPKICortexA55INST_RETIRED) * 1000), 0)" name="Branch MPKI" units="misses"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Branch Operations Percentage">
        <series color="19,148,180" description="This metric measures branch operations as a percentage of operations speculatively executed" expression="if(($BranchOperationsPercentageCortexA55INST_SPEC &gt; 0), min((($BranchOperationsPercentageCortexA55BR_IMMED_SPEC + $BranchOperationsPercentageCortexA55BR_INDIRECT_SPEC) / $BranchOperationsPercentageCortexA55INST_SPEC), 1), 0)" name="Branch Operations Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Branch Return Percentage">
        <series color="19,148,180" description="This metric measures the ratio of branches retired that are function returns to the total number of branches architecturally executed" expression="if(($BranchReturnPercentageCortexA55BR_RETIRED &gt; 0), min(($BranchReturnPercentageCortexA55BR_RETURN_RETIRED / $BranchReturnPercentageCortexA55BR_RETIRED), 1), 0)" name="Branch Return Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="Cycles Per Instruction">
        <series color="19,148,180" description="This metric measures the number of cycles per instructions retired" expression="if(($CyclesPerInstructionCortexA55INST_RETIRED &gt; 0), ($CyclesPerInstructionCortexA55CPU_CYCLES / $CyclesPerInstructionCortexA55INST_RETIRED), 0)" name="Cycles Per Instruction" units="cycles"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Crypto Operations Percentage">
        <series color="19,148,180" description="This metric measures crypto operations as a percentage of operations speculatively executed" expression="if(($CryptoOperationsPercentageCortexA55INST_SPEC &gt; 0), min(($CryptoOperationsPercentageCortexA55CRYPTO_SPEC / $CryptoOperationsPercentageCortexA55INST_SPEC), 1), 0)" name="Crypto Operations Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="DTLB MPKI">
        <series color="19,148,180" description="This metric measures the number of data TLB Walks per thousand instructions executed" expression="if(($DTLBMPKICortexA55INST_RETIRED &gt; 0), (($DTLBMPKICortexA55DTLB_WALK / $DTLBMPKICortexA55INST_RETIRED) * 1000), 0)" name="DTLB MPKI" units="misses"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="DTLB Walk Percentage">
        <series color="19,148,180" description="This metric measures the ratio of data TLB Walks to the total number of data TLB accesses. This gives an indication of the effectiveness of the data TLB accesses." expression="if(($DTLBWalkPercentageCortexA55L1D_TLB &gt; 0), min(($DTLBWalkPercentageCortexA55DTLB_WALK / $DTLBWalkPercentageCortexA55L1D_TLB), 1), 0)" name="DTLB Walk Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Frontend Stalled Cycles">
        <series color="19,148,180" description="This metric is the percentage of cycles that were stalled due to resource constraints in the frontend unit of the processor" expression="if(($FrontendStalledCyclesCortexA55CPU_CYCLES &gt; 0), min(($FrontendStalledCyclesCortexA55STALL_FRONTEND / $FrontendStalledCyclesCortexA55CPU_CYCLES), 1), 0)" name="Frontend Stalled Cycles" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Integer Operations Percentage">
        <series color="19,148,180" description="This metric measures scalar integer operations as a percentage of operations speculatively executed" expression="if(($IntegerOperationsPercentageCortexA55INST_SPEC &gt; 0), min(($IntegerOperationsPercentageCortexA55DP_SPEC / $IntegerOperationsPercentageCortexA55INST_SPEC), 1), 0)" name="Integer Operations Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="Instructions Per Cycle">
        <series color="19,148,180" description="This metric measures the number of instructions retired per cycle" expression="if(($InstructionsPerCycleCortexA55CPU_CYCLES &gt; 0), ($InstructionsPerCycleCortexA55INST_RETIRED / $InstructionsPerCycleCortexA55CPU_CYCLES), 0)" name="Instructions Per Cycle" units="instructions"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="ITLB MPKI">
        <series color="19,148,180" description="This metric measures the number of instruction TLB Walks per thousand instructions executed" expression="if(($ITLBMPKICortexA55INST_RETIRED &gt; 0), (($ITLBMPKICortexA55ITLB_WALK / $ITLBMPKICortexA55INST_RETIRED) * 1000), 0)" name="ITLB MPKI" units="misses"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="ITLB Walk Percentage">
        <series color="19,148,180" description="This metric measures the ratio of instruction TLB Walks to the total number of instruction TLB accesses. This gives an indication of the effectiveness of the instruction TLB accesses." expression="if(($ITLBWalkPercentageCortexA55L1I_TLB &gt; 0), min(($ITLBWalkPercentageCortexA55ITLB_WALK / $ITLBWalkPercentageCortexA55L1I_TLB), 1), 0)" name="ITLB Walk Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="L1D Cache Miss Percentage">
        <series color="19,148,180" description="This metric measures the ratio of level 1 data cache accesses missed to the total number of level 1 data cache accesses. This gives an indication of the effectiveness of the level 1 data cache." expression="if(($L1DCacheMissPercentageCortexA55L1D_CACHE &gt; 0), min(($L1DCacheMissPercentageCortexA55L1D_CACHE_REFILL / $L1DCacheMissPercentageCortexA55L1D_CACHE), 1), 0)" name="L1D Cache Miss Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="L1D Cache MPKI">
        <series color="19,148,180" description="This metric measures the number of level 1 data cache accesses missed per thousand instructions executed" expression="if(($L1DCacheMPKICortexA55INST_RETIRED &gt; 0), ((($L1DCacheMPKICortexA55L1D_CACHE_REFILL_RD + $L1DCacheMPKICortexA55L1D_CACHE_REFILL_WR) / $L1DCacheMPKICortexA55INST_RETIRED) * 1000), 0)" name="L1D Cache MPKI" units="misses"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="L1 Data TLB Miss Percentage">
        <series color="19,148,180" description="This metric measures the ratio of level 1 data TLB accesses missed to the total number of level 1 data TLB accesses. This gives an indication of the effectiveness of the level 1 data TLB." expression="if(($L1DataTLBMissPercentageCortexA55L1D_TLB &gt; 0), min(($L1DataTLBMissPercentageCortexA55L1D_TLB_REFILL / $L1DataTLBMissPercentageCortexA55L1D_TLB), 1), 0)" name="L1 Data TLB Miss Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="L1 Data TLB MPKI">
        <series color="19,148,180" description="This metric measures the number of level 1 data TLB accesses missed per thousand instructions executed" expression="if(($L1DataTLBMPKICortexA55INST_RETIRED &gt; 0), (($L1DataTLBMPKICortexA55L1D_TLB_REFILL / $L1DataTLBMPKICortexA55INST_RETIRED) * 1000), 0)" name="L1 Data TLB MPKI" units="misses"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="L1I Cache Miss Percentage">
        <series color="19,148,180" description="This metric measures the ratio of level 1 instruction cache accesses missed to the total number of level 1 instruction cache accesses. This gives an indication of the effectiveness of the level 1 instruction cache." expression="if(($L1ICacheMissPercentageCortexA55L1I_CACHE &gt; 0), min(($L1ICacheMissPercentageCortexA55L1I_CACHE_REFILL / $L1ICacheMissPercentageCortexA55L1I_CACHE), 1), 0)" name="L1I Cache Miss Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="L1I Cache MPKI">
        <series color="19,148,180" description="This metric measures the number of level 1 instruction cache accesses missed per thousand instructions executed" expression="if(($L1ICacheMPKICortexA55INST_RETIRED &gt; 0), (($L1ICacheMPKICortexA55L1I_CACHE_REFILL / $L1ICacheMPKICortexA55INST_RETIRED) * 1000), 0)" name="L1I Cache MPKI" units="misses"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="L1 Instruction TLB Miss Percentage">
        <series color="19,148,180" description="This metric measures the ratio of level 1 instruction TLB accesses missed to the total number of level 1 instruction TLB accesses. This gives an indication of the effectiveness of the level 1 instruction TLB." expression="if(($L1InstructionTLBMissPercentageCortexA55L1I_TLB &gt; 0), min(($L1InstructionTLBMissPercentageCortexA55L1I_TLB_REFILL / $L1InstructionTLBMissPercentageCortexA55L1I_TLB), 1), 0)" name="L1 Instruction TLB Miss Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="L1 Instruction TLB MPKI">
        <series color="19,148,180" description="This metric measures the number of level 1 instruction TLB accesses missed per thousand instructions executed" expression="if(($L1InstructionTLBMPKICortexA55INST_RETIRED &gt; 0), (($L1InstructionTLBMPKICortexA55L1I_TLB_REFILL / $L1InstructionTLBMPKICortexA55INST_RETIRED) * 1000), 0)" name="L1 Instruction TLB MPKI" units="misses"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="L2 Cache MPKI">
        <series color="19,148,180" description="This metric measures the number of level 2 unified cache accesses missed per thousand instructions executed. Note that cache accesses in this cache are either data memory access or instruction fetch as this is a unified cache." expression="if(($L2CacheMPKICortexA55INST_RETIRED &gt; 0), ((($L2CacheMPKICortexA55L2D_CACHE_REFILL_RD + $L2CacheMPKICortexA55L2D_CACHE_REFILL_WR) / $L2CacheMPKICortexA55INST_RETIRED) * 1000), 0)" name="L2 Cache MPKI" units="misses"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="L2 Unified TLB Miss Percentage">
        <series color="19,148,180" description="This metric measures the ratio of level 2 unified TLB accesses missed to the total number of level 2 unified TLB accesses. This gives an indication of the effectiveness of the level 2 TLB." expression="if(($L2UnifiedTLBMissPercentageCortexA55L2D_TLB &gt; 0), min(($L2UnifiedTLBMissPercentageCortexA55L2D_TLB_REFILL / $L2UnifiedTLBMissPercentageCortexA55L2D_TLB), 1), 0)" name="L2 Unified TLB Miss Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="L2 Unified TLB MPKI">
        <series color="19,148,180" description="This metric measures the number of level 2 unified TLB accesses missed per thousand instructions executed" expression="if(($L2UnifiedTLBMPKICortexA55INST_RETIRED &gt; 0), (($L2UnifiedTLBMPKICortexA55L2D_TLB_REFILL / $L2UnifiedTLBMPKICortexA55INST_RETIRED) * 1000), 0)" name="L2 Unified TLB MPKI" units="misses"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="L2D Cache MPKI">
        <series color="19,148,180" description="This metric measures the number of level 2 unified cache data accesses missed per thousand instructions executed. Note that cache accesses in this cache are either data memory access or instruction fetch as this is a unified cache." expression="if(($L2DCacheMPKICortexA55INST_RETIRED &gt; 0), ((($L2DCacheMPKICortexA55L2D_CACHE_REFILL_RD + $L2DCacheMPKICortexA55L2D_CACHE_REFILL_WR) / $L2DCacheMPKICortexA55INST_RETIRED) * 1000), 0)" name="L2D Cache MPKI" units="misses"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="L3 Cache Miss Percentage">
        <series color="19,148,180" description="This metric measures the ratio of level 3 cache accesses missed to the total number of level 3 cache accesses. This gives an indication of the effectiveness of the level 3 cache, which is a unified cache that stores both data and instruction. Note that cache accesses in this cache are either data memory access or instruction fetch as this is a unified cache." expression="if(($L3CacheMissPercentageCortexA55L3D_CACHE_RD &gt; 0), min(($L3CacheMissPercentageCortexA55L3D_CACHE_REFILL_RD / $L3CacheMissPercentageCortexA55L3D_CACHE_RD), 1), 0)" name="L3 Cache Miss Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="L3 Cache MPKI">
        <series color="19,148,180" description="This metric measures the number of level 3 unified cache accesses missed per thousand instructions executed. Note that cache accesses in this cache are either data memory access or instruction fetch as this is a unified cache." expression="if(($L3CacheMPKICortexA55INST_RETIRED &gt; 0), (($L3CacheMPKICortexA55L3D_CACHE_REFILL_RD / $L3CacheMPKICortexA55INST_RETIRED) * 1000), 0)" name="L3 Cache MPKI" units="misses"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="LL Cache Read Hit Percentage">
        <series color="19,148,180" description="This metric measures the ratio of last level cache read accesses hit in the cache to the total number of last level cache accesses. This gives an indication of the effectiveness of the last level cache for read traffic. Note that cache accesses in this cache are either data memory access or instruction fetch as this is a system level cache." expression="if(($LLCacheReadHitPercentageCortexA55LL_CACHE_RD &gt; 0), min((($LLCacheReadHitPercentageCortexA55LL_CACHE_RD - $LLCacheReadHitPercentageCortexA55LL_CACHE_MISS_RD) / $LLCacheReadHitPercentageCortexA55LL_CACHE_RD), 1), 0)" name="LL Cache Read Hit Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="LL Cache Read Miss Percentage">
        <series color="19,148,180" description="This metric measures the ratio of last level cache read accesses missed to the total number of last level cache accesses. This gives an indication of the effectiveness of the last level cache for read traffic. Note that cache accesses in this cache are either data memory access or instruction fetch as this is a system level cache." expression="if(($LLCacheReadMissPercentageCortexA55LL_CACHE_RD &gt; 0), min(($LLCacheReadMissPercentageCortexA55LL_CACHE_MISS_RD / $LLCacheReadMissPercentageCortexA55LL_CACHE_RD), 1), 0)" name="LL Cache Read Miss Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="no" title="LL Cache Read MPKI">
        <series color="19,148,180" description="This metric measures the number of last level cache read accesses missed per thousand instructions executed" expression="if(($LLCacheReadMPKICortexA55INST_RETIRED &gt; 0), (($LLCacheReadMPKICortexA55LL_CACHE_MISS_RD / $LLCacheReadMPKICortexA55INST_RETIRED) * 1000), 0)" name="LL Cache Read MPKI" units="misses"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Load as Load/Store Operations Percentage">
        <series color="19,148,180" description="This metric measures load operations as a percentage of load and store operations speculatively executed" expression="if(($LoadAsLoadStoreOperationsPercentageCortexA55LDST_SPEC &gt; 0), min(($LoadAsLoadStoreOperationsPercentageCortexA55LD_SPEC / $LoadAsLoadStoreOperationsPercentageCortexA55LDST_SPEC), 1), 0)" name="Load as Load/Store Operations Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Load Operations Percentage">
        <series color="19,148,180" description="This metric measures load operations as a percentage of operations speculatively executed" expression="if(($LoadOperationsPercentageCortexA55INST_SPEC &gt; 0), min(($LoadOperationsPercentageCortexA55LD_SPEC / $LoadOperationsPercentageCortexA55INST_SPEC), 1), 0)" name="Load Operations Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Load/Store Operations Percentage">
        <series color="19,148,180" description="This metric measures load and store operations as a percentage of operations speculatively executed" expression="if(($LoadStoreOperationsPercentageCortexA55INST_SPEC &gt; 0), min(($LoadStoreOperationsPercentageCortexA55LDST_SPEC / $LoadStoreOperationsPercentageCortexA55INST_SPEC), 1), 0)" name="Load/Store Operations Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Retired Instructions Percentage">
        <series color="19,148,180" description="This metric measures the percentage of instructions speculatively executed that are subsequently retired" expression="if(($RetiredInstructionsPercentageCortexA55INST_SPEC &gt; 0), min(($RetiredInstructionsPercentageCortexA55INST_RETIRED / $RetiredInstructionsPercentageCortexA55INST_SPEC), 1), 0)" name="Retired Instructions Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Floating Point Operations Percentage">
        <series color="19,148,180" description="This metric measures scalar floating point operations as a percentage of operations speculatively executed" expression="if(($FloatingPointOperationsPercentageCortexA55INST_SPEC &gt; 0), min(($FloatingPointOperationsPercentageCortexA55VFP_SPEC / $FloatingPointOperationsPercentageCortexA55INST_SPEC), 1), 0)" name="Floating Point Operations Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Advanced SIMD Operations Percentage">
        <series color="19,148,180" description="This metric measures advanced SIMD operations as a percentage of total operations speculatively executed" expression="if(($AdvancedSIMDOperationsPercentageCortexA55INST_SPEC &gt; 0), min(($AdvancedSIMDOperationsPercentageCortexA55ASE_SPEC / $AdvancedSIMDOperationsPercentageCortexA55INST_SPEC), 1), 0)" name="Advanced SIMD Operations Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Store as Load/Store Operations Percentage">
        <series color="19,148,180" description="This metric measures store operations as a percentage of load and store operations speculatively executed" expression="if(($StoreAsLoadStoreOperationsPercentageCortexA55LDST_SPEC &gt; 0), min(($StoreAsLoadStoreOperationsPercentageCortexA55ST_SPEC / $StoreAsLoadStoreOperationsPercentageCortexA55LDST_SPEC), 1), 0)" name="Store as Load/Store Operations Percentage" units="percent"/>
    </chart>
   <chart rendering_type="line" series_composition="overlay" percentage="yes" title="Store Operations Percentage">
        <series color="19,148,180" description="This metric measures store operations as a percentage of operations speculatively executed" expression="if(($StoreOperationsPercentageCortexA55INST_SPEC &gt; 0), min(($StoreOperationsPercentageCortexA55ST_SPEC / $StoreOperationsPercentageCortexA55INST_SPEC), 1), 0)" name="Store Operations Percentage" units="percent"/>
    </chart>
    <select-metric id="ARMv8_Cortex_A55_metric_backend_stall_interlock_bound" />
    <select-metric id="ARMv8_Cortex_A55_metric_backend_stalled_cycles" />
    <select-metric id="ARMv8_Cortex_A55_metric_branch_direct_ratio" />
    <select-metric id="ARMv8_Cortex_A55_metric_branch_misprediction_ratio" />
    <select-metric id="ARMv8_Cortex_A55_metric_branch_mpki" />
    <select-metric id="ARMv8_Cortex_A55_metric_branch_percentage" />
    <select-metric id="ARMv8_Cortex_A55_metric_branch_return_ratio" />
    <select-metric id="ARMv8_Cortex_A55_metric_cpi" />
    <select-metric id="ARMv8_Cortex_A55_metric_crypto_percentage" />
    <select-metric id="ARMv8_Cortex_A55_metric_dtlb_mpki" />
    <select-metric id="ARMv8_Cortex_A55_metric_dtlb_walk_ratio" />
    <select-metric id="ARMv8_Cortex_A55_metric_frontend_stalled_cycles" />
    <select-metric id="ARMv8_Cortex_A55_metric_integer_dp_percentage" />
    <select-metric id="ARMv8_Cortex_A55_metric_ipc" />
    <select-metric id="ARMv8_Cortex_A55_metric_itlb_mpki" />
    <select-metric id="ARMv8_Cortex_A55_metric_itlb_walk_ratio" />
    <select-metric id="ARMv8_Cortex_A55_metric_l1d_cache_miss_ratio" />
    <select-metric id="ARMv8_Cortex_A55_metric_l1d_cache_mpki" />
    <select-metric id="ARMv8_Cortex_A55_metric_l1d_tlb_miss_ratio" />
    <select-metric id="ARMv8_Cortex_A55_metric_l1d_tlb_mpki" />
    <select-metric id="ARMv8_Cortex_A55_metric_l1i_cache_miss_ratio" />
    <select-metric id="ARMv8_Cortex_A55_metric_l1i_cache_mpki" />
    <select-metric id="ARMv8_Cortex_A55_metric_l1i_tlb_miss_ratio" />
    <select-metric id="ARMv8_Cortex_A55_metric_l1i_tlb_mpki" />
    <select-metric id="ARMv8_Cortex_A55_metric_l2_cache_mpki" />
    <select-metric id="ARMv8_Cortex_A55_metric_l2_tlb_miss_ratio" />
    <select-metric id="ARMv8_Cortex_A55_metric_l2_tlb_mpki" />
    <select-metric id="ARMv8_Cortex_A55_metric_l2d_cache_mpki" />
    <select-metric id="ARMv8_Cortex_A55_metric_l3_cache_miss_ratio" />
    <select-metric id="ARMv8_Cortex_A55_metric_l3_cache_mpki" />
    <select-metric id="ARMv8_Cortex_A55_metric_ll_cache_read_hit_ratio" />
    <select-metric id="ARMv8_Cortex_A55_metric_ll_cache_read_miss_ratio" />
    <select-metric id="ARMv8_Cortex_A55_metric_ll_cache_read_mpki" />
    <select-metric id="ARMv8_Cortex_A55_metric_load_ls_percentage" />
    <select-metric id="ARMv8_Cortex_A55_metric_load_percentage" />
    <select-metric id="ARMv8_Cortex_A55_metric_load_store_percentage" />
    <select-metric id="ARMv8_Cortex_A55_metric_retired_insns_percent" />
    <select-metric id="ARMv8_Cortex_A55_metric_scalar_fp_percentage" />
    <select-metric id="ARMv8_Cortex_A55_metric_simd_percentage" />
    <select-metric id="ARMv8_Cortex_A55_metric_store_ls_percentage" />
    <select-metric id="ARMv8_Cortex_A55_metric_store_percentage" />
</template>
